
    
function [ae ei exe_t] = test3fold(estimfn,out_dir,db_file,svbase,fold,clabel)
  
  DB = open(db_file);

  truel = DB.groundtruth_illuminants;
  truel = truel ./ repmat(sqrt(sum(truel.^2,2)),[1 3]);
  
  N = length(DB.all_image_names);
  ae = zeros(N,1);
  exe_t= zeros(N,1);
  ei = zeros(N,3);
  testidx = [fold:3:N];  
    
    for i = 1:length(testidx)
      tic
      fprintf('\r Testing %d of %d files           ',i,length(testidx));
      foldsv = sprintf('%s%d.mat',svbase,fold);
      pc_names{i} = [out_dir '/' DB.all_image_names{testidx(i)} '.pc.mat'];
      if nargin > 5
        w = estimfn(pc_names{i},foldsv,clabel(testidx(i)));
      else
        w = estimfn(pc_names{i},foldsv);
      end
      exe_t(testidx(i))=toc;
      ei(testidx(i),:) = w(:)'; 
      ae(testidx(i)) = acosd(sum(w(:)' .* truel(testidx(i),:)));
    end;
    fprintf('\n');